<?php

/**
 * @package         Advanced Custom Fields
 * @version         0.8.1 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2019 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die;

JLoader::register('ACF_Field', JPATH_PLUGINS . '/system/acf/helper/plugin.php');

class PlgFieldsACFTelephone extends ACF_Field
{
	/**
	 *  Field's Class
	 *
	 *  @var  string
	 */
	protected $class = 'input-xlarge';
	
	/**
	 *  Field's Hint Description
	 *
	 *  @var  string
	 */
	protected $hint = '';

	/**
	 * Transforms the field into a DOM XML element and appends it as a child on the given parent.
	 *
	 * @param   stdClass    $field   The field.
	 * @param   DOMElement  $parent  The field node parent.
	 * @param   JForm       $form    The form.
	 *
	 * @return  DOMElement
	 *
	 * @since   3.7.0
	 */
	public function onCustomFieldsPrepareDom($field, DOMElement $parent, JForm $form)
	{
		if (!$fieldNode = parent::onCustomFieldsPrepareDom($field, $parent, $form))
		{
			return $fieldNode;
		}

		// Set custom class and type
		$fieldNode->setAttribute('class', $this->class);
		$fieldNode->setAttribute('type', 'tel');
		
		// Get the Input Mask entered on Field settings
		$tel_mask = $field->fieldparams->get('tel_mask');
		
		if (isset($tel_mask)) {

			// Add `acf-input-mask` class on this field as it has an input mask
			$fieldNode->setAttribute('class', $this->class . ' acf-input-mask');
			
			$doc = JFactory::getDocument();
			$doc->addScript(JURI::root(true) . '/plugins/fields/acftelephone/assets/js/inputmask.js');
			$doc->addScript(JURI::root(true) . '/plugins/fields/acftelephone/assets/js/script.js');

			$inputMasks = $doc->getScriptOptions('acf_telephone_masks');
			$inputMasks[] = $tel_mask;
			$doc->addScriptOptions('acf_telephone_masks', $inputMasks);
		}

		return $fieldNode;
	}
}
