// ACF Telephone Init Input Mask on Fields that have a mask
function initInputMask() {

    // Check if the Inputmask library is available
    if (typeof Inputmask == 'undefined') {
        return;
    }

    // Get masks from back-end
    var acf_telephone_masks = Joomla.getOptions('acf_telephone_masks');

    // If no masks are available, abort
    if (acf_telephone_masks.length == 0) {
        return;
    }

    // Loop through all input mask fields and apply the mask
    var inputs = document.querySelectorAll(".acf-input-mask");
    for (var i = 0; i < inputs.length; i++) {
        Inputmask(acf_telephone_masks[i], { jitMasking: false, showMaskOnHover: false }).mask(inputs[i]);
        Inputmask.setValue(inputs[i], inputs[i].defaultValue);
    }
    
}

// When the DOM is loaded, start the input mask process
document.addEventListener("DOMContentLoaded", function(event) {
    initInputMask();
});