<?php

/**
 * @package         Advanced Custom Fields
 * @version         2.3.0 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2022 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die;

JLoader::register('ACF_Field', JPATH_PLUGINS . '/system/acf/helper/plugin.php');

if (!class_exists('ACF_Field'))
{
	JFactory::getApplication()->enqueueMessage('Advanced Custom Fields System Plugin is missing', 'error');
	return;
}

class PlgFieldsACFConvertForms extends ACF_Field
{	
	/**
	 * Transforms the field into a DOM XML element and appends it as a child on the given parent.
	 *
	 * @param   stdClass    $field   The field.
	 * @param   DOMElement  $parent  The field node parent.
	 * @param   Form        $form    The form.
	 *
	 * @return  DOMElement
	 *
	 * @since   3.7.0
	 */
	public function onCustomFieldsPrepareDom($field, DOMElement $parent, Joomla\CMS\Form\Form $form)
	{
		if (!$fieldNode = parent::onCustomFieldsPrepareDom($field, $parent, $form))
		{
			return;
		}

		$form->addFieldPath(JPATH_ADMINISTRATOR . '/components/com_convertforms/models/forms/fields');

		$fieldNode->setAttribute('type', 'convertforms');

		$option = new \DOMElement('option');
		$option->textContent = htmlspecialchars('- ' . JText::_('JSELECT') . ' -', ENT_COMPAT, 'UTF-8');
		$element = $fieldNode->appendChild($option);

		return $fieldNode;
	}
}
