<?php
/**
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2018 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
 */

// No direct access to this file
defined('_JEXEC') or die;

JFormHelper::loadFieldClass('text');

class JFormFieldACFMap extends JFormFieldText
{
	/**
	 * Method to get the field input markup.
	 *
	 * @return  string  The field input markup.
	 */
	public function getInput()
	{
		$value = is_string($this->value) && !empty($this->value) ? (json_decode($this->value) ? json_decode($this->value, true) : null) : json_decode(json_encode($this->value), true);
		$markers = isset($value['markers']) ? (is_string($value['markers']) ? json_decode($value['markers'], true) : $value['markers']) : null;

		$default_coords = (string) $this->element['default_coords'];

		$map_center = null;

		$map_center_value = (string) $this->element['map_center'];
		if ($map_center_value && $map_center_value !== ',')
		{
			$map_center = explode(',', (string) $this->element['map_center']);
			$map_center = is_array($map_center) ? implode(',', array_slice($map_center, 0, 2)) : '';
		}

		$payload = [
			'name' => $this->name,
			'show_address' => false,
			'width' => 700,
			'required' => $this->required,
			'zoom_level' => 'fitbounds',
			'map_center' => $map_center,
			'id' => $this->id,
			'show_markers_list' => true,
			'css_class' => ' side-by-side',
			
			'scale' => false,
			
			
		];

		if ($default_coords)
		{
			$default_coords = array_map('trim', explode(',', $default_coords));
			if (count($default_coords) === 2)
			{
				$payload['lat'] = $default_coords[0];
				$payload['long'] = $default_coords[1];
			}
		}

		if ($markers)
		{
			$payload['markers'] = $markers;
		}

		return \NRFramework\Widgets\Helper::render('MapEditor', $payload);
	}
}