<?php

/**
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2023 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
 */

namespace ACF\Helpers;

defined('_JEXEC') or die;

class Field
{
	/**
	 * Returns whether the ACF custom field is widget-based.
	 * 
	 * @param   string  $type
	 * 
	 * @return  array
	 */
	public static function isWidgetBased($type = '')
	{
		if (!$type)
		{
			return false;
		}

		$type = self::getWidgetName($type);

		return \NRFramework\Widgets\Helper::find($type);
	}

	/**
	 * Returns the widget name of an ACF custom field.
	 * 
	 * @param   string  @type
	 * 
	 * @return  string
	 */
	public static function getWidgetName($type = '')
	{
		// Remove the "acf" prefix
		$type = str_replace('acf', '', $type);

		// Map for any ACF fields that do not automatically translate to a Widget
		$map = [
			'address' => 'MapAddress'
		];

		// Transform a field type to its corresponding widget from the map
		return isset($map[$type]) ? $map[$type] : $type;
	}
}