<?php

/**
 * @package         Advanced Custom Fields
 * @version         2.7.0 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2023 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die('Restricted access');

JFormHelper::loadFieldClass('list');

use \ACF\Helpers\Field;
use \NRFramework\Widgets\Helper;

class JFormFieldACFFieldLayoutOverrides extends JFormFieldList
{
    /**
     * Method to get a list of options for a list input.
     *
     * @return    array   An array of JHtml options.
     */
    protected function getOptions()
    {
        $layouts = [
            'default' => 'JOPTION_USE_DEFAULT'
        ];

		$field_type = (string) $this->element['field_type'];
        $field_widget_name = Field::getWidgetName($field_type);
		if ($layout_overrides = Helper::getLayoutOverrides($field_widget_name))
		{
			$layouts = array_merge($layouts, $layout_overrides);
		}

        foreach ($layouts as $key => $title)
        {
            $options[] = JHTML::_('select.option', $key, JText::_($title));
        }   

        return $options;
    }

	public function getInput()
	{
		$field_type = (string) $this->element['field_type'];

		$original_path = implode(DIRECTORY_SEPARATOR, [JPATH_PLUGINS, 'system', 'nrframework', 'layouts', 'widgets', strtolower(Field::getWidgetName($field_type))]) . '/default.php';

        $field_widget_name = Field::getWidgetName($field_type);
		$new_path = Helper::getLayoutOverridePath($field_widget_name) . '/LAYOUTNAME.php';
		
		$note = '<div class="acf-field-setting-note" style="padding-top:5px;">' . sprintf(JText::_('ACF_OVERRIDE_WIDGET_BASED_FIELD_LAYOUT_DESC'), JText::_('PLG_FIELDS_' . $field_type . '_LABEL'), $original_path, $new_path) . '</div>';
		
		return parent::getInput() . $note;
	}
}