<?php

/**
 * @package         Convert Forms
 * @version         1.0.5 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2016 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die('Restricted access');
jimport('joomla.filesystem.file');

$app = JFactory::getApplication();

// Access check.
if (!JFactory::getUser()->authorise('core.manage', 'com_convertforms'))
{
	$app->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'), 'error');
	return;
}

require_once JPATH_PLUGINS . '/system/nrframework/helpers/functions.php';
require_once JPATH_COMPONENT_ADMINISTRATOR.'/helpers/convertforms.php';

NRFrameworkFunctions::loadLanguage('com_convertforms');

// Do some checks
if (!isFrameworkInstalled()) {
	$app->enqueueMessage(JText::_('Novarain Framework plugin is not installed. Convert Forms cannot function.'), 'error');
}

if (pluginIsDisabled("nrframework")) {
	$app->enqueueMessage(JText::_('Novarain Framework plugin is not enabled. Convert Forms cannot function.'), 'notice');
}

if (pluginIsDisabled("convertforms")) {
	$app->enqueueMessage(JText::_('Convert Forms plugin is not enabled.'), 'notice');
}

// Load component's CSS/JS files
ConvertFormsHelper::loadassets();

// Perform the Request task
$controller = JControllerLegacy::getInstance('ConvertForms');
$controller->execute($app->input->get('task'));
$controller->redirect();

// Custom functions
function pluginIsDisabled($plugin) 
{
	$p = JPluginHelper::getPlugin('system', $plugin);

	if (!isset($p->name)) {
		return true;
	}	

	return false;
}

function isFrameworkInstalled() 
{
	jimport('joomla.filesystem.file');

	if (!JFile::exists(JPATH_PLUGINS . '/system/nrframework/nrframework.php')) {
		return false;
	}

	return true;
}