<?php

/**
 * @package         Convert Forms
 * @version         1.0.5 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2016 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die('Restricted access');

require_once JPATH_PLUGINS . "/system/nrframework/helpers/smarttags.php";

class ConvertFormsSmartTags
{
	public static $smartTags = array(
        "lead.id"          => "",
        "lead.date"        => "",
        "lead.campaign_id" => "",
        "lead.form_id"     => "",
        "lead.visitor_id"  => "",
        "field.email"      => "",
        "all_fields"       => ""
    );

	public static function get()
    {
        return self::$smartTags;
    }

    public static function prepare($lead = null)
    {
        $tags = array();
       
        if (!is_object($lead) && is_int($lead))
        {
            // Add component include paths for models and tables
            $path = JPATH_ADMINISTRATOR . '/components/com_convertforms/';
            JModelLegacy::addIncludePath($path . 'models');
            JTable::addIncludePath($path . 'tables');

            $model = JModelLegacy::getInstance('Conversion', 'ConvertFormsModel', array('ignore_request' => true));
            $lead = $model->getItem($lead);
        }

        if (is_object($lead))
        {
            $tags = array(
                "lead.id"          => $lead->id,
                "lead.date"        => $lead->created,
                "lead.campaign_id" => $lead->campaign_id,
                "lead.form_id"     => $lead->form_id,
                "lead.visitor_id"  => $lead->visitor_id,
                "field.email"      => $lead->email
            );

            if (is_array($lead->params))
            {
                $all_fields = "<div><strong>Email</strong>: " . $lead->email . "</div>";

                foreach ($lead->params as $key => $value)
                {
                    // Skip integration wide fields
                    if (strpos($key, "sync_") !== false)
                    {
                        continue;
                    }

                    $value = is_array($value) ? implode(", ", $value) : $value;
                    $tags["field.". $key] = $value;
                    $all_fields .= "<div><strong>" . ucfirst($key) . "</strong>: " . $value . "</div>";
                }

                $tags["all_fields"] = $all_fields;
            }
        }

        return $tags;
    }

    public static function replace(&$string, $lead = null)
    {
        $smartTags = new NRSmartTags();
        $localTags = self::prepare($lead);
        $smartTags->add($localTags);
        return $smartTags->replace($string);
    }
}

?>