<?php

/**
 * @package         Convert Forms
 * @version         1.0.5 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2016 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die('Restricted access');
extract($displayData);

?>

<div <?php echo trim($boxattributes) ?>>
	<form method="post" action="#">
		<?php if ($hascontent) { ?>
		<div class="cf-content-wrap cf-col-16 <?php echo $contentclasses ?>">
			<div class="cf-content cf-col-16">
				<?php if (isset($image)) { ?>
					<div class="cf-content-img cf-col-16 cf-text-center <?php echo $imagecontainerclasses; ?>">
						<img 
							alt="<?php echo $params->get("imagealt"); ?>"
							class="<?php echo implode(" ", $imageclasses) ?>" 
							style="<?php echo implode(";", $imagestyles) ?>"
							src="<?php echo $image ?>"
						/>
					</div>
				<?php } ?>
				<?php if (!$textIsEmpty) { ?>
				<div class="cf-content-text cf-col <?php echo $textcontainerclasses; ?>" >
					<?php echo $params->get("text"); ?>
				</div>
				<?php } ?>
			</div>
		</div>
		<?php } ?>
		<div class="cf-form-wrap cf-col-16 <?php echo implode(" ", $formclasses) ?>" style="<?php echo implode(";", $formstyles) ?>">
			<div class="cf-response"></div>
			<div class="cf-form cf-col-16">
				<div class="cf-fields cf-fields-<?php echo count($fields) ?> <?php echo $fieldscontainerclasses ?>">
					<?php 
					foreach ($fields as $key => $field) { ?>
						<?php

							$fieldID     = "form" . $id . "-field" . $field->name;
							$required    = $field->required ? "required" : "";
							$placeholder = isset($field->placeholder) ? 'placeholder="' . htmlspecialchars($field->placeholder, ENT_COMPAT, 'UTF-8') . '"' : "";
						?>
						<div class="cf-control-group">
							<?php if (!$params->get("hidelabels", true)) { ?>
							<div class="cf-control-label">
								<label class="cf-label" style="<?php echo implode(";", $labelStyles) ?>" for="<?php echo $fieldID; ?>"><?php echo $field->label ?></label>
							</div>
							<?php } ?>
							<div class="cf-control-input">
								<?php switch ($field->type): 
									case "text": 
									case "email":
									case "number": ?>
										<input name="cf[<?php echo $field->name ?>]" type="<?php echo $field->type ?>"  id="<?php echo $fieldID; ?>" <?php echo $placeholder ?> <?php echo $required ?> <?php echo $fieldattributes ?>>
									<?php break; ?>

									<?php case "checkbox": ?>
										<?php foreach ($field->dropdownoptions->choices as $choiceKey => $choice) { ?>
											<div class="cf-checkbox-group">
												<input name="cf[<?php echo $field->name ?>][]"
													type="checkbox" 
													value="<?php echo $choice['value']; ?>"
													id="<?php echo $fieldID . "_" . $choiceKey ?>"

													<?php if (isset($choice['selected']) && ($choice['selected'])) { ?> 
														checked="checked"
													<?php } ?>

													<?php echo $required  . " " . $fieldattributes ?>
												>
												<label class="cf-label" for="<?php echo $fieldID . "_" . $choiceKey; ?>">
													<?php echo $choice['label'] ?>
												</label>
											</div>
										<?php } ?>
									<?php break; ?>
									<?php case "dropdown": ?>
										<select name="cf[<?php echo $field->name ?>]" id="<?php echo $fieldID; ?>" <?php echo $required ?> <?php echo $fieldattributes ?>>
											<?php foreach ($field->dropdownoptions->choices as $choiceKey => $choice) { ?>
												<option 
													value="<?php echo $choice['value'] ?>" 
													<?php if (isset($choice['selected']) && ($choice['selected'])) { ?> 
														selected="selected"
													<?php } ?>
													<?php if (isset($choice['disabled'])) { ?> disabled <?php } ?>>
													<?php echo $choice['label']; ?>
												</option>
											<?php } ?>
										</select>
									<?php break; ?>

									<?php case "textarea": ?>
										<textarea name="cf[<?php echo $field->name ?>]" id="<?php echo $fieldID; ?>" <?php echo $placeholder ?> <?php echo $fieldattributes ?> <?php echo $required ?> rows="<?php echo $field->textareaheight ?>"></textarea>
									<?php break; ?>

								<?php endswitch; ?>
							</div>
						</div>
					<?php } ?>
				</div>
				<div class="submit cf-text-<?php echo $params->get("btnalign"); ?> <?php echo $buttonContainerClasses ?>">
					<button type="submit" <?php echo $buttonattributes ?>>
						<span class="cf-btn-text"><?php echo $params->get("btntext") ?></span>
						<span class="cf-spinner-container">
							<span class="cf-spinner">
								<span class="bounce1"></span>
								<span class="bounce2"></span>
								<span class="bounce3"></span>
							</span>
						</span>
					</button>
				</div>
			</div>
			<?php if (!$footerIsEmpty) { ?>
			<div class="cf-footer">
				<?php echo $params->get("footer"); ?>
			</div>
			<?php } ?>
		</div>

		<?php foreach ($hiddenfields as $key => $field) { ?>
			<input type="hidden" name="cf[<?php echo $field->name ?>]" value="<?php echo $field->value; ?>">
		<?php } ?>

		<?php echo JHtml::_( 'form.token' ); ?>
		<input type="hidden" name="cf[form_id]" value="<?php echo $id ?>">

		<?php echo $params->get('customcode', ''); ?>
	</form>
</div>

<?php 
    if (isset($styles))
    {
    	echo '<style>'.implode("\n", $styles).'</style>';
    }
?>