<?php

/**
 * @package         Convert Forms
 * @version         1.0.5 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2016 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

use Joomla\Registry\Registry;
use Joomla\String\StringHelper;

defined('_JEXEC') or die('Restricted access');
 
// import Joomla modelform library
jimport('joomla.application.component.modeladmin');

/**
 * Conversion Model Class
 */
class ConvertFormsModelConversion extends JModelAdmin
{
    /**
     *  The database object
     *
     *  @var  object
     */
    private $db;

    /**
     * Constructor.
     *
     * @param   array  $config  An optional associative array of configuration settings.
     *
     * @see     JModelLegacy
     * @since   1.6
     */
    public function __construct($config = array())
    {
        parent::__construct($config);
        $this->db = JFactory::getDbo();
    }

    /**
     * Returns a reference to the a Table object, always creating it.
     *
     * @param       type    The table type to instantiate
     * @param       string  A prefix for the table class name. Optional.
     * @param       array   Configuration array for model. Optional.
     * @return      JTable  A database object
     * @since       2.5
     */
    public function getTable($type = 'Conversion', $prefix = 'ConvertFormsTable', $config = array()) 
    {
        return JTable::getInstance($type, $prefix, $config);
    }

    /**
     * Method to get the record form.
     *
     * @param       array   $data           Data for the form.
     * @param       boolean $loadData       True if the form is to load its own data (default case), false if not.
     * @return      mixed   A JForm object on success, false on failure
     * @since       2.5
     */
    public function getForm($data = array(), $loadData = true)
    {
        // Get the form.
        $form = $this->loadForm('com_convertforms.conversion', 'conversion', array('control' => 'jform', 'load_data' => $loadData));

        if (empty($form)) 
        {
            return false;
        }

        return $form;
    }

    /**
     * Method to get the data that should be injected in the form.
     *
     * @return    mixed    The data for the form.
     */
    protected function loadFormData()
    {
        // Check the session for previously entered form data.
        $data = JFactory::getApplication()->getUserState('com_convertforms.edit.conversion.data', array());

        if (empty($data))
        {
            $data = $this->getItem();
        }

        return $data;
    }

    /**
     *  Validate data before saving
     *
     *  @param   object  $form   The form to validate
     *  @param   object  $data   The data to validate
     *  @param   string  $group  
     *
     *  @return  array           The validated data
     */
    public function validate($form, $data, $group = null)
    {
        $newdata = array();
        $params  = array();

        $this->_db->setQuery('SHOW COLUMNS FROM #__convertforms_conversions');

        $dbkeys = $this->_db->loadObjectList('Field');
        $dbkeys = array_keys($dbkeys);

        // Unknown fields go to param table column
        foreach ($data as $key => $val)
        {
            if (in_array(strtolower($key), $dbkeys))
            {
                $newdata[strtolower($key)] = $val;
            }
            else
            {
                $params[$key] = $val;
            }
        }

        $newdata['params'] = json_encode($params);

        // Set missing campaign ID
        // TODO: Move to table class
        if (!isset($data["campaign_id"]))
        {
            JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_convertforms/tables');

            $formModel = JModelLegacy::getInstance('Form', 'ConvertFormsModel', array('ignore_request' => true));
            $form      = $formModel->getItem($data["form_id"]);
            $newdata["campaign_id"] = $form->campaign;
        }

        return $newdata;
    }

    /**
     *  Get a conversion item
     *
     *  @param   interger  $pk  The conversion row primary key
     *
     *  @return  object         The conversion object
     */
    public function getItem($pk = null)
    {
        if (!$item = parent::getItem($pk))
        {
            return;
        }

        // Load Form & Campaign Model
        $modelForm = JModelLegacy::getInstance('Form', 'ConvertFormsModel', array('ignore_request' => true));
        $modelCampaign = JModelLegacy::getInstance('Campaign', 'ConvertFormsModel', array('ignore_request' => true));

        $item->form = $modelForm->getItem($item->form_id);
        $item->campaign = $modelCampaign->getItem($item->campaign_id);

        return $item;
    }

    /**
     *  Create a new conversion based on the post data.
     *  
     *  If the combination of email and campaign_id already exists in the database the record will be updated.
     *
     *  @return  object     The new conversion row object
     */
    public function createConversion()
    {
        // Validate data
        $data = $this->validate(null, JFactory::getApplication()->input->get('cf', array(), 'ARRAY'));

        // Log debug message
        // @TODO Debug checking should be moved to log method
        if (JDEBUG)
        {
            $debugData = urldecode(http_build_query($data, '', ', '));
            ConvertFormsHelper::log('New Lead: ' . $debugData);
        }

        if (!isset($data["email"]) || empty($data["email"]))
        {
            throw new Exception("Invalid email field");
        }

        // Everything seems fine. Let's save data to the database.
        if (!$this->save($data))
        {
            throw new Exception($this->getError());
        }

        $lastInsertID = $this->db->insertid();

        // Log debug message
        if (JDEBUG)
        {
            ConvertFormsHelper::log('Lead saved #' . $lastInsertID);
        }

        return $this->getItem($lastInsertID);
    }
}

