<?php

/**
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2017 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

// No direct access to this file
defined('_JEXEC') or die;
JFormHelper::loadFieldClass('list');
require_once JPATH_ADMINISTRATOR . '/components/com_convertforms/helpers/convertforms.php';

class JFormFieldCampaigns extends JFormFieldList
{
    /**
     * Method to get a list of options for a list input.
     *
     * @return      array           An array of JHtml options.
     */
    protected function getOptions() 
    {
        $lists = ConvertFormsHelper::getCampaigns();

        if (!count($lists))
        {
            return;
        }

        $options = array();

        foreach ($lists as $option)
        {
            $options[] = JHTML::_('select.option', $option->id, $option->name);
        }

        $options = array_merge(parent::getOptions(), $options);
        return $options;
    }
}