<?php

/**
 * @package         Convert Forms
 * @version         1.0.5 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2016 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die;

require_once __DIR__ . '/script.install.helper.php';

class Com_ConvertFormsInstallerScript extends Com_ConvertFormsInstallerScriptHelper
{
	public $name = 'CONVERTFORMS';
	public $alias = 'convertforms';
	public $extension_type = 'component';

	public function onAfterInstall()
	{
		# PRO-START
		$this->moveFrontEndImages();
		# PRO-END
		
		if ($this->install_type == "update") 
        {
	        if (version_compare($this->installedVersion, '0.3.1', 'l'))
	 	    {
	 	    	$this->app->enqueueMessage('The dropdown and checkbox fields have been updated and it\'s recommended to check your forms as the change is not 100% backwards compatible.', 'notice');
				$this->fixDropDownChoices();
			}
		}
	}

	/**
	 *  Moves front-end based images from /media/ folder to /images/
	 *
	 *  @return  void
	 */
	private function moveFrontEndImages()
	{
		$source      = JPATH_SITE . "/media/com_convertforms/img/convertforms";
		$destination = JPATH_SITE . "/images/convertforms";

		if (!JFolder::exists($source))
		{
			return;
		}

		if (!JFolder::copy($source, $destination, null, true))
		{
			return;
		}

		JFolder::delete($source);
	}

	/**
	 *  Transforms dropdown plain written choices in textarea into an array
	 *
	 *  @return  void
	 */
	private function fixDropDownChoices()
	{
        // Add component include paths for models and tables
        $componentPath = JPATH_ADMINISTRATOR . '/components/com_convertforms/';
        JModelLegacy::addIncludePath($componentPath . 'models');
        JTable::addIncludePath($componentPath . 'tables');

		$modelForm = JModelLegacy::getInstance('Form', 'ConvertFormsModel', array('ignore_request' => true));

		if (!$forms = $this->getForms())
		{
			return;
		}

		foreach ($forms as $key => $form)
		{
			if (!isset($form->fields))
			{
				continue;
			}

			$fields = $form->fields;

			foreach ($fields as $key => $field)
			{
				if ($field->type != 'dropdown')
				{
					continue;
				}

				$choices = $field->dropdownoptions;

				if (!is_string($choices))
				{
					continue;
				}

				$options = explode("\n", $choices);
				$optionsNew = array();

				foreach ($options as $optionKey => $option)
				{
		     		$parts = explode(":", $option);
		            $label = trim(str_replace(array("\n", "\r"), '', $parts[0]));
		            $value = isset($parts[1]) ? trim($parts[1]) : $label;

					$optionsNew['choices'][$optionKey] = array(
						'label' => $label,
						'value' => $value
					);
				}

		        // Load form's database row to update
		       	$table = $modelForm->getTable();
		        $table->load($form->id);

		        $params = json_decode($table->params);

		        if (!is_object($params))
		        {
		            $params = new stdClass();
		        }

		        // Check form has the field key
		        if (!isset($params->fields->{$key}))
		        {
		        	continue;
		        }

		        $params->fields->{$key}->dropdownoptions = $optionsNew;
		        $params->fields->{$key}->placeholder = '';

		        $table->params = json_encode($params);
		        $table->store();
			}
		}
	}

	/**
	 *  Get Forms List
	 *
	 *  @return  object
	 */
	private function getForms()
	{
		$modelForms = JModelLegacy::getInstance('Forms', 'ConvertFormsModel', array('ignore_request' => true));
		return $modelForms->getItems();
	}
}

