<?php

/**
 * @package         Convert Forms
 * @version         1.0.5 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2016 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die('Restricted access');

JHtml::_('bootstrap.tooltip');

$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn  = $this->escape($this->state->get('list.direction'));

$user = JFactory::getUser();

?>

<form action="<?php echo JRoute::_('index.php?option=com_convertforms&view=conversions'); ?>" class="clearfix" method="post" name="adminForm" id="adminForm">
    <?php if (!empty($this->sidebar)) : ?>
        <div id="j-sidebar-container" class="span2">
            <?php echo $this->sidebar; ?>
        </div>
        <div id="j-main-container" class="span10">
    <?php else : ?>
        <div id="j-main-container">
    <?php endif;?>

    <?php
        echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this));
    ?>

    <table class="adminlist nrTable table">
        <thead>
            <tr>
                <th class="center" width="2%"><?php echo JHtml::_('grid.checkall'); ?></th>
                <th width="3%" class="nowrap hidden-phone" align="center">
                    <?php echo JHtml::_('searchtools.sort', 'JSTATUS', 'a.state', $listDirn, $listOrder); ?>
                </th>
                <th>
                    <?php echo JHtml::_('searchtools.sort', 'COM_CONVERTFORMS_EMAIL', 'a.email', $listDirn, $listOrder); ?>
                </th>
                <th width="18%">
                    <?php echo JText::_('NR_NAME') ?>
                </th>
                <th width="18%">
                    <?php echo JHtml::_('searchtools.sort', 'COM_CONVERTFORMS_CAMPAIGN', 'a.campaign_id', $listDirn, $listOrder); ?>
                </th>
                <th width="18%">
                    <?php echo JHtml::_('searchtools.sort', 'COM_CONVERTFORMS_FORM', 'a.form_id', $listDirn, $listOrder); ?>
                </th>
                <th width="18%">
                    <?php echo JHtml::_('searchtools.sort', 'COM_CONVERTFORMS_DATE', 'a.created', $listDirn, $listOrder); ?>
                </th>
                <th width="3%" class="nowrap hidden-phone">
                    <?php echo JHtml::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
                </th>
            </tr>
        </thead>
        <tbody>
            <?php if (count($this->items)) { ?>
                <?php foreach($this->items as $i => $item): ?>
                    <?php 
                        $canChange  = $user->authorise('core.edit.state', 'com_convertforms.conversion.' . $item->id);
                    ?>
                    <tr class="row<?php echo $i % 2; ?> <?php echo isset($item->params->sync_error) ? "error" : "" ?>">
                        <td class="center"><?php echo JHtml::_('grid.id', $i, $item->id); ?></td>
                        <td class="center">
                            <div class="btn-group">
                                <?php echo JHtml::_('jgrid.published', $item->state, $i, 'conversions.', $canChange); ?>
                                <?php
                                if ($canChange)
                                {
                                    JHtml::_('actionsdropdown.' . ((int) $item->state === -2 ? 'un' : '') . 'trash', 'cb' . $i, 'conversions');
                                    echo JHtml::_('actionsdropdown.render', $this->escape($item->id));
                                }
                                ?>
                            </div>
                        </td>
                        <td>
                            <?php 
                                $toolTipContent = "";

                                foreach ($item->params as $key => $param)
                                {
                                    if (strpos($key, "sync_") !== false || empty($param))
                                    {
                                        continue;
                                    }

                                    $param = is_array($param) ? implode(", ", $param) : $param;

                                    $toolTipContent .= "<div><b>" . $key ."</b>: " . $param . "</div>";
                                }
                            ?>

                            <?php if ($toolTipContent) { ?>
                            
                            <span class="hasPopover"
                                data-placement="top"
                                data-title="Fields"
                                data-content="<?php echo $toolTipContent ?>">
                                <?php echo $this->escape($item->email); ?>
                            </span>

                            <?php } else { ?>
                                <?php echo $this->escape($item->email); ?>
                            <?php } ?>
                        </td>
                        <td><?php if (isset($item->params->name)) { echo $this->escape($item->params->name); } ?></td>
                        <td>
                            <?php echo $item->campaign_name ?>
                            <?php if ((isset($item->params->sync_service)) && (isset($item->params->sync_error))) { ?>
                                <span class="hasPopover icon icon-info" 
                                    data-placement="top"
                                    data-title="<?php echo JText::_("PLG_CONVERTFORMS_" . $item->params->sync_service . "_ALIAS"); ?>"
                                    data-content="<?php echo $item->params->sync_error ?>"
                                    style="color:red;">
                                </span>
                            <?php } ?>
                        </td>
                        <td><?php echo $item->form_name ?></td>
                        <td><?php echo $item->created ?></td>
                        <td><?php echo $item->id; ?></td>
                    </tr>
                <?php endforeach; ?>  
            <?php } else { ?>
                <tr>
                    <td align="center" colspan="8">
                        <div align="center">
                            <?php echo ConvertFormsHelper::noItemsFound(); ?>
                        </div>
                    </td>
                </tr>
            <?php } ?>  
        </tbody>
        <tfoot>
			<tr><td colspan="8"><?php echo $this->pagination->getListFooter(); ?></td></tr>
        </tfoot>
    </table>
    <div>
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="boxchecked" value="0" />
        <?php echo JHtml::_('form.token'); ?>
    </div>
    </div>
</form>
<?php include_once(JPATH_COMPONENT_ADMINISTRATOR."/layouts/footer.php"); ?>
