<?php

/**
 * @package         Convert Forms
 * @version         1.0.5 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2016 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die('Restricted access');
 
// import Joomla view library
jimport('joomla.application.component.view');

include_once JPATH_PLUGINS . "/system/nrframework/helpers/fonts.php";
 
/**
 * Item View
 */
class ConvertFormsViewForm extends JViewLegacy
{
    /**
     * display method of Item view
     * @return void
     */
    public function display($tpl = null) 
    {
        // Check for errors.
        if (count($errors = $this->get('Errors'))) 
        {
            JFactory::getApplication()->enqueueMessage(implode("\n", $errors), 'error');
            return false;
        }

        // Assign the Data
        $this->form  = $this->get('Form');
        $this->item  = $this->get('Item');
        $this->isnew = (!isset($_REQUEST["id"])) ? true : false;
        $this->tabs  = $this->get('Tabs');

        $doc = JFactory::getDocument();
        $doc->addScript(JURI::root(true) . "/media/editors/tinymce/tinymce.min.js");
        
        NRFrameworkFunctions::addMedia("convertforms.editor.sys.css","com_convertforms");

        // Load SubForm Showon Fix on Joomla version <= 3.7
        // https://github.com/joomla/joomla-cms/pull/12511
        if (version_compare(JVERSION, "3.7", '<'))
        {
            NRFrameworkFunctions::addMedia("showon.subform.fix.js", "com_convertforms");
        }

        NRFrameworkFunctions::addMedia("cookie.js", "com_convertforms");

        $fonts = new NRFonts();
        $doc->addScriptDeclaration('var ConvertFormsGoogleFonts = '.json_encode($fonts->getFontGroup("google")));

        // Set the toolbar
        $this->addToolBar();

        // Display the template
        parent::display($tpl);
    }

    /**
     * Setting the toolbar
     */
    protected function addToolBar() 
    {
        $input = JFactory::getApplication()->input;
        $input->set('hidemainmenu', true);
        $isNew = ($this->item->id == 0);

        JToolBarHelper::title($isNew ? JText::_('COM_CONVERTFORMS_NEW_FORM') : JText::_('COM_CONVERTFORMS_EDIT_FORM') . ": " . $this->item->name . " #". $this->item->id);

        JToolbarHelper::apply('form.apply');
        JToolBarHelper::custom('form.reload', 'refresh', 'refresh', 'Reload', false);
        JToolBarHelper::cancel('form.cancel', $isNew ? 'JTOOLBAR_CANCEL' : 'JTOOLBAR_CLOSE');
    }
}