<?php

/**
 * @package         Convert Forms
 * @version         1.0.5 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2016 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die('Restricted access');

require_once JPATH_ADMINISTRATOR . "/components/com_convertforms/helpers/smarttags.php";
require_once JPATH_PLUGINS . "/system/nrframework/helpers/email.php";

class plgConvertFormsEmails extends JPlugin
{
    /**
     *  Add plugin fields to the form
     *
     *  @param   JForm   $form  
     *  @param   object  $data
     *
     *  @return  boolean
     */
    public function onConvertFormsFormPrepareForm($form, $data)
    {
        $form->loadFile(__DIR__ . "/form/form.xml", false);
        return true;
    }

    /**
     *  Content is passed by reference, but after the save, so no changes will be saved.
     *  Method is called right after the content is saved.
     * 
     *  @param   string  $lead 		  The Conversion data
     *  @param   bool    $model       The Conversions Model
     *  @param   bool    $isNew       If the Conversion has just been created
     * 
     *  @return  void
     */
    public function onConvertFormsConversionAfterSave($lead, $model, $isNew)
    {
        if (!isset($lead->form->sendnotifications) || !$lead->form->sendnotifications)
        {
            return;
        }

        if (!isset($lead->form->emails) || !is_array($lead->form->emails))
        {
            return;
        }

        // Send email queue
        foreach ($lead->form->emails as $key => $email)
        {
            // Replace {variables}
            $email = ConvertFormsSmartTags::replace($email, $lead);

            // Send mail
            $mailer = new NREmail($email);
            $mailer->send();
        }
    }   
}