<?php 

/**
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2017 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die('Restricted access');

/**
 *  Novarain Framework Emailer
 */
class NREmail
{
    /**
     *  Indicates the last error
     *
     *  @var  string
     */
    private $error;

    /**
     *  Email Object
     *
     *  @var  email data to be sent
     */
    private $email;

    /**
     *  Required elements for a valid email object
     *
     *  @var  array
     */
    private $requiredKeys = array(
        "from_email",
        "from_name",
        "recipient",
        "subject",
        "body"
    );

    /**
     *  Class constructor
     */
    public function __construct($email)
    {
        $this->email = $email;
    }

    /**
     *  Validates Email Object
     *
     *  @param   array  $email  The email object
     *
     *  @return  boolean        Returns true if the email object is valid
     */
    public function validate()
    {
        if (!$email = $this->email)
        {
            return;
        }

        if (!is_array($email) || !count($email))
        {
            return false;
        }

        $valid = true;

        foreach ($this->requiredKeys as $key)
        {
            if (!isset($email[$key]) || empty($email[$key]))
            {
                $valid = false;
                $this->error = "Error sending email: The $key field is either missing or invalid.";
                break;
            }
        }

        return $valid;
    }

    /**
     *  Sending emails
     *
     *  @param   array  $email  The mail objecta
     *
     *  @return  mixed          Returns true on success. Throws exeption on fail.
     */
    public function send()
    {
        $email = $this->email;

        // Validate first the email object
        if (!$this->validate($email))
        {
            throw new Exception($this->error);
        }

        $mailer = JFactory::getMailer();

        // Email Sender
        $mailer->setSender(
            array(
                $email["from_email"],
                $email["from_name"]
            )
        );

        // Reply-to
        if (isset($email["reply_to"]))
        {
            $mailer->addReplyTo($email["reply_to"]);
        }

        $mailer
            // Recipient - Support multiple recipients separated by comma
            ->addRecipient(explode(",", $email["recipient"]))
            ->isHTML(true)
            ->setSubject($email["subject"])
            ->setBody($email["body"]);

        // Send mail
        $send = $mailer->Send();
        
        if ($send !== true)
        {
            $this->error = 'Error sending email: ' . $send->__toString();
            throw new Exception($this->error);
        }

        return true;
    }
}

?>