<?php
/**
 * @package         Convert Forms
 * @version         5.1.1 Free
 *
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            https://www.tassos.gr
 * @copyright       Copyright © 2024 Tassos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
 */

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Object\CMSObject;
use Joomla\CMS\Language\Text;

class PlgButtonConvertforms extends CMSPlugin
{
	/**
	 * Load the language file on instantiation.
	 *
	 * @var    boolean
	 */
	protected $autoloadLanguage = true;

    /**
     *  Application Object
     *
     *  @var  object
     */
    protected $app;

	/**
	 * ConvertForms Button
	 *
	 * @param  string  $name  The name of the button to add
	 *
	 * @return CMSObject  The button object
	 */
	public function onDisplay($name)
	{
		$component = $this->app->input->getCmd('option');
		$basePath  = $this->app->isClient('administrator') ? '' : 'administrator/';
		$link      = $basePath . 'index.php?option=com_convertforms&amp;view=editorbutton&amp;layout=button&amp;tmpl=component&e_name=' . $name . '&e_comp='. $component;

		$button          = new CMSObject();
		$button->modal   = true;
		$button->class   = 'btn cf';
		$button->link    = $link;
		$button->text    = Text::_('PLG_EDITORS-XTD_CONVERTFORMS_BUTTON_TEXT');
		$button->name    = 'vcard';

		$button->options = [
			'height'     => '200px',
			'bodyHeight' => '180px',
			'modalWidth' => '250px',
		];

		return $button;
	}
}