<?php

/**
 * @package         EngageBox
 * @version         7.1.0-RC3 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2020 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;

$box = $displayData;
$params = Tassos\EngageBox\Helper::getParams();

// Load core.js as we need to read the csrf.token and system.paths values.
HTMLHelper::_('behavior.core');

// Load the animate.css library
HTMLHelper::stylesheet('com_rstbox/vendor/animate.min.css', ['relative' => true, 'version' => 'auto']);

// Load the engagebox.js script
HTMLHelper::script('com_rstbox/engagebox.js', ['relative' => true, 'version' => 'auto']);

if ($params->get('loadCSS', true))
{
	HTMLHelper::stylesheet('com_rstbox/engagebox.css', ['relative' => true, 'version' => 'auto']);
}

// Add Custom CSS
if ($box->params->get('customcss'))
{
	Factory::getDocument()->addStyleDeclaration($box->params->get('customcss'));
}


?>
<div data-id="<?php echo $box->id ?>" 
	class="eb-inst eb-hide <?php echo implode(' ', $box->classes) ?>"
	data-options='<?php echo json_encode($box->settings, JSON_HEX_APOS) ?>'
	data-type='<?php echo $box->params->get('mode') ?>'
	<?php if (!empty($box->styles_container)) { ?>style="<?php echo $box->styles_container; ?>"<?php } ?>
	<?php if ($box->rtl) { ?>dir="rtl"<?php } ?>>

	<?php
	$box->close_button_placement = 'outside';
	echo $this->sublayout('closebutton', $box);
	?>

	<div class="eb-dialog <?php echo implode(' ', $box->dialog_classes) ?>" role="dialog" aria-modal="true" id="dialog<?php echo $box->id ?>" aria-label="dialog<?php echo $box->id; ?>">
		
		<?php
		$box->close_button_placement = 'inside';
		echo $this->sublayout('closebutton', $box);
		?>
	
		<div class="eb-container">
			<?php if ($box->params->get('showtitle', true)) { ?>
				<div class="eb-header">
					<?php echo $box->name ?>
				</div>
			<?php } ?>
			<div class="eb-content">
				<?php
					echo $box->content;
					
				?>
			</div>
		</div>
	</div>	
</div>
<?php 
	if ($box->triggermethod == 'floatingbutton' || $box->params->get('floating_button_show_on_close'))
	{
		echo $this->sublayout('floatingbutton', $box); 
	}