<?php

/**
 * @package         EngageBox
 * @version         7.1.0-RC3 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2019 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
 
/**
 * Item View
 */
class RstboxViewItem extends HtmlView
{
    /**
     * display method of Item view
     * @return void
     */
    public function display($tpl = null) 
    {
        // Check for errors.
        if (count($errors = $this->get('Errors'))) 
        {
            Factory::getApplication()->enqueueMessage($errors, 'error');
            return false;
        }

        // Load Smart Tags
        if (Factory::getApplication()->input->get('layout') == "smarttags")
        {
            
        } else 
        {
            // Assign the Data
            $this->form     = $this->get('Form');
            $this->item     = $this->get('Item');
            
            // Redirect to list page when the popup we are trying to edit does not exist.
            if (!$this->item)
            {
                Factory::getApplication()->enqueueMessage(Text::sprintf('This popup does not exist.'), 'error');
                Factory::getApplication()->redirect('index.php?option=com_rstbox&view=items');
            }
            
            $this->isnew    = (!isset($_REQUEST["id"])) ? true : false;
            $this->addToolBar();
        }

        // Display the template
        parent::display($tpl);
    }

    /**
     * Setting the toolbar
     */
    protected function addToolBar() 
    {
        $input = Factory::getApplication()->input;
        $input->set('hidemainmenu', true);
        $isNew = ($this->item->id == 0);

        ToolBarHelper::title($isNew ? Text::_('New Box') : Text::_('Edit Box: ' . $this->item->name . " - ". $this->item->id));

        $toolbar = Toolbar::getInstance();
        $saveGroup = $toolbar->dropdownButton('save-group');
        $saveGroup->configure(
            function (Toolbar $childBar)
            {
                $childBar->apply('item.apply');
                $childBar->save('item.save');
                $childBar->save2new('item.save2new');
                $childBar->save2copy('item.save2copy');
            }
        );
        
        

        $toolbar->cancel('item.cancel', 'JTOOLBAR_CLOSE');
    }
}