<?php

/**
 * @package         EngageBox
 * @version         7.1.1-RC1 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2020 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

namespace Tassos\EngageBox;

defined('_JEXEC') or die('Restricted access');

use Tassos\EngageBox\Box;
use Tassos\EngageBox\Helper;
use NRFramework\Cache;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\Registry\Registry;
use Joomla\CMS\Factory;
use Joomla\CMS\Table\Table;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;

class Boxes
{
    public static function render()
    {
        $db = Factory::getDbo();

        $query = $db->getQuery(true)
            ->select($db->quoteName('id'))
            ->from($db->quoteName('#__rstbox'))
            ->where($db->quoteName('published') . ' = 1');

        // If visitor is not logged-in as a Super User, get non-test-mode boxes only.
        if (!Factory::getUser()->authorise('core.admin'))
        { 
            $query->where($db->quoteName('testmode') . ' = 0');
        }
         
        $db->setQuery($query);
        
        if (!$ids = $db->loadColumn())
        {
            return;
        }

        $html = '';

        foreach ($ids as $id)
        {
            // Get box object
            $box = Box::get($id);

            // Render box
            $html .= Box::render($box);
        }

        

        return $html;
    }

    /**
     * Get all boxes regardless their published state
     *
     * @return array
     */
    public static function getAll()
    {
        $hash = 'boxes';

        if (Cache::has($hash))
        {
            return Cache::read($hash);
        }

        BaseDatabaseModel::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_rstbox/' . 'models');
        Table::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_rstbox/' . 'tables');
        
        $model = BaseDatabaseModel::getInstance('Items', 'RstboxModel', ['ignore_request' => true]);
        $result = $model->getItems();

        return Cache::set($hash, $result);
    }
}