<?php

/**
 * @package         EngageBox
 * @version         7.1.1-RC1 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2019 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use NRFramework\Functions;

class JFormFieldBoxes extends ListField
{
    /**
     * The box list
     *
     * @var object
     */
    private $boxes;

    private $exclude_editing_box;

    /**
     * Render the input field
     *
     * @return void
     */
    protected function getInput()
    {
        $this->exclude_editing_box = $this->element['excludeeditingbox'] == 'true';

        if (!$this->boxes = $this->getBoxes())
        {
            Functions::loadLanguage('com_rstbox');

            return Text::_('COM_RSTBOX_NO_BOXES_FOUND');
        }

        return parent::getInput();
    }

    /**
     * Method to get a list of options for a list input.
     *
     * @return    array   An array of options.
     */
    protected function getOptions()
    {
        if (!$this->boxes)
        {
            return;
        }

        $options = [];

        foreach ($this->boxes as $box)
        {
            // Exclude active editing box
            if ($this->getEditingBoxID() == $box->id)
            {
                array_unshift($options, HTMLHelper::_('select.option', $box->id, Text::_('COM_ENGAGEBOX_THIS_BOX')));
                continue;
            }

            $option = HTMLHelper::_('select.option', $box->id, $box->name . ' (' . $box->id . ')');
            $options[] = $option;
        }   

        return array_merge(parent::getOptions(), $options);
    }

    /**
     * Get list of boxes
     *
     * @return void
     */
    private function getBoxes()
    {
        BaseDatabaseModel::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_rstbox/' . 'models');

        $model = BaseDatabaseModel::getInstance('Items', 'RstboxModel', array('ignore_request' => true));
        $model->setState('filter.state', 1);
        $model->setState('filter.impressions', false);

        // Exclude active editing box
        if ($this->exclude_editing_box && $current_box = $this->getEditingBoxID())
        {
            $model->setState('filter.exclude', $current_box);
        }

        return $model->getItems();
    }

    private function getEditingBoxID()
    {
        $input = Factory::getApplication()->input;

        /**
         * First check the keys `request_option` and `request_layout` respectively instead of `option` and `layout`
         * in case an AJAX request needs to sends us these data but cannot use the `option` and `layout` as different
         * values are needed for the AJAX request to function properly.
         * 
         * i.e. ConditionBuilder's "Viewed Another Box" should not display the current box when fetching the rule fields
         * via AJAX. Since its not possible to get the current box ID after the AJAX has happened, we send the `id`
         * (popup ID) alongside the `request_option` (com_rstbox) and `request_layout` (edit) parameters.
         */
        $option = $input->get('request_option') ? $input->get('request_option') : $input->get('option');
        $layout = $input->get('request_layout') ? $input->get('request_layout') : $input->get('layout');

        if ($option == 'com_rstbox' && $layout == 'edit')
        {
            return $input->getInt('id');
        }

        return false;
    }
}