<?php

/**
 * @package         EngageBox
 * @version         6.3.8 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2020 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

namespace EngageBox;

defined('_JEXEC') or die('Restricted access');

use EngageBox\Helper;
use EngageBox\Box;
use Joomla\CMS\Factory;

/**
 *  EngageBox Assignments Class
 *  @todo - Refactor all local assignments to be using the framework's Condition class and let the framework run the checks.
 */
class Assignments
{
	/**
	 *  Item
	 *
	 *  @var  object
	 */
	private $box;

	/**
	 *  Local assignments list
	 *
	 *  @var  array
	 */
	private $assignments = array(
        
		'cookietype',
        'offline'
    );

	/**
	 *  Class Constructor
	 *
	 *  @param  object  $item  The object to be checked
	 */
	public function __construct($box)
	{
        $this->box = $box;
	}

	/**
     *  Pass all checks
     *
     *  @return  boolean  Returns true if all assignments pass
     */
    public function passAll()
    {
        // Temporary fix for the Cookie assignment check as the cookie property doesn't have the 'assign_' prefix.
        // @todo - see class's comment.
        $this->box->params->set('assign_cookietype', true);

        $pass = true;

        foreach ($this->assignments as $key => $assignment)
        {
            // Break if not passed
            if (!$pass)
            {
                break;
            }
            
            $method = 'pass' . $assignment;

            // Skip item if there is no assosiated method
            if (!method_exists($this, $method))
            {
                continue;
            }

            $assign = 'assign_' . $assignment;

            // Skip item if assignment is missing
            if (!$this->box->params->exists($assign))
            {
                continue;
            }

            $pass = $this->$method();
        }

        return $pass;
    }

    /**
     *  Pass Check for Offline Mode
     *
     *  @return  bool
     */
    private function passOffline()
    {
        // Skip check if offline mode is disabled
        if (!Factory::getConfig()->get('offline', false))
        {
            return true;
        }

        $component   = Helper::getParams();
        $globalState = $component->get('assign_offline', true);
        $boxState    = $this->box->params->get('assign_offline', null);

        return is_null($boxState) ? $globalState : $boxState;
    }

    /**
     *  Pass Check for Box Cookie
     *
     *  @return  bool
     */
    private function passCookieType()
    {
        // Skip if assignment is disabled
        if ($this->box->params->get('cookietype') == 'never')
        {
            return true;
        }

        // Skip if box is on Test Mode and a Super User is logged in
        if ($this->box->testmode && Factory::getUser()->authorise('core.admin'))
        {
            return true;
        }

        $cookie = new Cookie($this->box->id);

        return !$cookie->exist();
    }

    
}