<?php

/**
 * @package         EngageBox
 * @version         6.3.8 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2020 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Form\Field\GroupedlistField;

class JFormFieldEBAnimationOut extends GroupedlistField
{
    protected $layout = 'joomla.form.field.groupedlist-fancy-select';

    /**
     * Method to get a list of options for a list input.
     *
     * @return      array           An array of options.
     */
    protected function getGroups()
    {
        $data = [
			'Classic' => [
				'transition.fadeOut' => 'fadeOut',
				'transition.swoopOut' => 'swoopOut',
				'transition.whirlOut' => 'whirlOut',
				'transition.shrinkOut' => 'shrinkOut',
				'transition.expandOut' => 'expandOut',
			],
			
		];

        $groups = [];

        foreach ($data as $groupKey => $value)
        {
            foreach ($value as $_key => $_value)
			{
				$groupLabel = '';
				
				
                $groups[$groupLabel][] = HTMLHelper::_('select.option', $_key, $_value);
			}
        }

        return $groups;
    }
	
    protected function getInput()
    {
		$class = (string) $this->element['class'];

		$search_placeholder = (string) $this->element['search_placeholder'];
		if ($search_placeholder)
		{
			$this->class = $class . '" search-placeholder="' . Text::_($search_placeholder);
		}
		else
		{
			$this->class = $class;
		}

		return parent::getInput();
	}
}