<?php

/**
 * @package         EngageBox
 * @version         7.1.1 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2020 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

class JFormFieldEBTriggersList extends ListField
{
    /**
     * Method to get a list of options for a list input.
     *
     * @return    array   An array of options.
     */
    protected function getOptions()
    {
        $triggers = [
            'pageload'        => 'COM_RSTBOX_ITEM_TRIGGER_PAGELOAD',
            'onclick'         => 'COM_RSTBOX_ITEM_TRIGGER_ONCLICK',
            'ondemand'        => 'COM_RSTBOX_ITEM_TRIGGER_ONDEMAND',
            
        ];

        foreach ($triggers as $key => $title)
        {
            $options[] = HTMLHelper::_('select.option', $key, Text::_($title));
        }   

        return array_merge(parent::getOptions(), $options);
    }
}