<?php

/**
 * @package         EngageBox
 * @version         7.1.1 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2020 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Factory;

HTMLHelper::_('behavior.formvalidator');
HTMLHelper::_('behavior.keepalive');

$doc = Factory::getDocument();
$doc->addScriptDeclaration('
    window.EBReloadForm = () => {
        const isJ3 = typeof Joomla.loadingLayer == "function";
        if (isJ3) {
            Joomla.loadingLayer("show");
        } else {
            document.body.appendChild(document.createElement("joomla-core-loader"));
        }
        document.querySelector("input[name=task]").value = "item.reload";
        Joomla.submitform("item.reload", document.getElementById("adminForm"));
    };
');


$doc->getWebAssetManager()->useScript('webcomponent.core-loader');


// Fix Joomla 4's very high CodeMirror max-height.
if (defined('t_isJ4'))
{
    $doc->addStyleDeclaration('
        .CodeMirror {
            max-height: 500px;
        }
    ');
}
$doc->addStyleDeclaration('
    .CodeMirror {
        margin: 0;
    }
    
    joomla-editor-codemirror > p.small.float-end {
        display: none;
    }
');


NRFramework\HTML::renderProOnlyModal();




function tabSetStart()
{
    echo HTMLHelper::_('uitab.startTabSet', 'myTab', ['active' => 'general', 'recall' => true]);
}

function tabSetEnd()
{
    echo HTMLHelper::_('uitab.endTabSet');
}

function tabStart($name, $title)
{
    echo HTMLHelper::_('uitab.addTab', 'myTab', $name, Text::_($title));
}

function tabEnd()
{
    echo HTMLHelper::_('uitab.endTab');
}

NRFramework\HTML::fixFieldTooltips();

?>

<!-- Test Mode Notice -->
<?php if ($this->item->testmode) { ?>
	<div class="alert alert-warning text-center">
		<?php echo Text::_('COM_RSTBOX_ITEM_TESTMODE_NOTICE'); ?>
	</div>
<?php } ?>

<div class="rstbox rstbox-item form-horizontal">
    <form action="<?php echo Route::_('index.php?option=com_rstbox&layout=edit&id='.(int) $this->item->id); ?>" method="post" name="adminForm" id="adminForm">
        <div class="row">
            <div class="span9 col-md-9">
                <div class="rowTop mt-2 mb-4">
                    <?php echo $this->form->renderFieldset("top") ?>
                </div>

                <?php tabSetStart() ?>

                <!-- Content Tab -->
                <?php tabStart('general', 'COM_RSTBOX_CONTENT'); ?>
                <div class="boxtype <?php echo $this->form->getData()->get('boxtype') ?>">
                    <?php echo $this->form->renderFieldset($this->form->getData()->get('boxtype')); ?>
                </div>
                <?php tabEnd() ?>

                <!-- Appearance Tab -->
                <?php tabStart('appearance', 'COM_RSTBOX_APPEARANCE'); ?>
                    <?php echo $this->form->renderFieldset("appearance") ?>
                <?php tabEnd() ?>

                <!-- Trigger Tab -->
                <?php tabStart('trigger', 'COM_RSTBOX_BOX_BEHAVIOR'); ?>
                <div class="row">
                    <?php echo $this->form->renderFieldset("items") ?>
                </div>
                <?php tabEnd() ?>

                <!-- Publishing Assignments Tab -->
                <?php 
                    tabStart('displayConditions', 'NR_PUBLISHING_ASSIGNMENTS');
                    echo $this->form->renderFieldSet('display_conditions');
                    tabEnd();
                ?>

                <!-- Params -->

                <?php 
                    $fieldSets = $this->form->getFieldsets();

                    foreach ($fieldSets as $name => $fieldset)
                    {
                        if (!isset($fieldset->tag) || $fieldset->tag != 'params')
                        {
                            continue;
                        }

                        tabStart($fieldset->name, $fieldset->label);

                        if ($fieldset->description)
                        {
                            echo '
                                <div class="fieldset-desc alert alert-info">
                                    <span>' . Text::_($fieldset->description) . '</span>
                                    <a href="' . $fieldset->help . '" target="_blank"><span class="icon icon-help"></span> ' . Text::_("JHELP") . '</a>
                                </div>
                                ';
                        }

                        echo $this->form->renderFieldset($fieldset->name);
                        tabEnd();
                    }
                ?>

                <!-- Advanced Tab -->
                <?php
                    tabStart('advanced', 'NR_ADVANCED');
                    echo $this->form->renderFieldset('advanced');
                    tabEnd();
                ?>

                <input type="hidden" name="task" value="item.edit" />
                <?php echo HTMLHelper::_('form.token'); ?>
                <?php tabSetEnd() ?>
            </div>

            <div class="span3 col-md-3 px-4 form-vertical">
                <?php echo $this->form->renderFieldset('general') ?>
            </div>
        </div>

        <?php 
            // Render all fieldsets supposed to be displayed in a popup
            $fieldSets = $this->form->getFieldsets();

            foreach ($fieldSets as $name => $fieldset)
            {
                if (!isset($fieldset->popup))
                {
                    continue;
                }
                
                $content = '<div style="padding:1rem">' . $this->form->renderFieldset($fieldset->name) . '</div>';

                $modal =  HTMLHelper::_('bootstrap.renderModal', $fieldset->name, [
                    'title' => Text::_($fieldset->label),
                    'closeButton' => true,
                    'footer' => '<a type="button" class="btn btn-secondary" data-bs-dismiss="modal" aria-hidden="true">Close</a>'
                ], $content);

                // Add a unique CSS class to fix some styling issues on J3
                echo str_replace('modal hide', 'modal hide popup_settings_modal', $modal);
            }
        ?>

    </form>
</div>