<?php

/**
 * @package         EngageBox
 * @version         7.1.1 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2019 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/
defined('_JEXEC') or die('Restricted access');
 
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;

/**
 * Items View
 */
class RstboxViewItems extends HtmlView
{
    /**
     * Items view display method
     * 
     * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
     * 
     * @return  mixed  A string if successful, otherwise a JError object.
     */
    function display($tpl = null) 
    {
        $this->items         = $this->get('Items');
        $this->state         = $this->get('State');
        $this->pagination    = $this->get('Pagination');
        $this->filterForm    = $this->get('FilterForm');
        $this->activeFilters = $this->get('ActiveFilters');
        $this->config        = Tassos\EngageBox\Helper::getParams();

        // Check for errors.
        if (count($errors = $this->get('Errors'))) 
        {
            Factory::getApplication()->enqueueMessage($errors, 'error');
            return false;
        }

        // Set the toolbar
        $this->addToolBar();

        // Display the template
        parent::display($tpl);
    }

    /**
     *  Add Toolbar to layout
     */
    protected function addToolBar() 
    {
        $canDo = Joomla\CMS\Helper\ContentHelper::getActions('com_rstbox');
        $state = $this->get('State');
        $viewLayout = Factory::getApplication()->input->get('layout', 'default');


        $toolbar = Toolbar::getInstance('toolbar');

        if ($viewLayout == 'import')
        {
            Factory::getDocument()->setTitle(Text::_('RSTBOX') . ': ' . Text::_('COM_RSTBOX_IMPORT_POPUP'));
            ToolbarHelper::title(Text::_('RSTBOX') . ': ' . Text::_('COM_RSTBOX_IMPORT_POPUP'));
            ToolbarHelper::back();
        }
        else
        {
            ToolbarHelper::title(Text::_('RSTBOX'));
            
            if ($canDo->get('core.create'))
            {
                $newGroup = $toolbar->dropdownButton('new-group')
                    ->text('NR_NEW')
                    ->toggleSplit(false)
                    ->icon('fas fa-plus')
                    ->buttonClass('btn btn-action');

                $newGroup->configure(
                    function (Toolbar $childBar)
                    {
                        $childBar->popupButton('new')->text('NR_NEW')->selector('ebSelectTemplate')->icon('icon-new')->buttonClass('btn btn-success');
                        $childBar->addNew('item.add')->text('COM_RSTBOX_BLANK_POPUP');
                        $childBar->standardButton('import')->text('NR_IMPORT')->task('items.import')->icon('icon-upload');
                    }
                );
            }

            $dropdown = $toolbar->dropdownButton('status-group')
                ->text('JTOOLBAR_CHANGE_STATUS')
                ->toggleSplit(false)
                ->icon('fas fa-ellipsis-h')
                ->buttonClass('btn btn-action')
                ->listCheck(true);

            $childBar = $dropdown->getChildToolbar();
            
            if ($canDo->get('core.edit.state'))
            {
                $childBar->publish('items.publish')->listCheck(true);
                $childBar->unpublish('items.unpublish')->listCheck(true);
                $childBar->standardButton('copy')->text('JTOOLBAR_DUPLICATE')->task('items.copy')->listCheck(true);
                $childBar->standardButton('export')->text('NR_EXPORT')->task('items.export')->icon('icon-download')->listCheck(true);
                $childBar->standardButton('refresh')->text('COM_RSTBOX_RESET_STATISTICS')->task('items.reset')->listCheck(true);
                $childBar->standardButton('removecookie')->text('COM_RSTBOX_REMOVE_COOKIE')->task('items.removeCookie')->icon('icon-minus-circle')->listCheck(true);
                $childBar->trash('items.trash')->listCheck(true);
            }

            if ($this->state->get('filter.state') == -2)
            {
                $toolbar->delete('items.delete')
                    ->text('JTOOLBAR_EMPTY_TRASH')
                    ->message('JGLOBAL_CONFIRM_DELETE')
                    ->listCheck(true);
            }

            if ($canDo->get('core.admin'))
            {
                $toolbar->preferences('com_rstbox');
            }

            $toolbar->help('JHELP', false, "http://www.tassos.gr/joomla-extensions/engagebox/docs");
        }
    }
}