<?php

/**
 * @package         EngageBox
 * @version         7.1.1 Free
 *
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2019 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
 */

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;

class RstboxViewRstbox extends HtmlView
{
	/**
	 * Items view display method
	 * @return void
	 */
	function display($tpl = null)
	{
		if ($this->getLayout() == 'button')
		{
			// Load plugin language file
			NRFramework\Functions::loadLanguage("plg_editors-xtd_engagebox");

			// Get editor name
			$eName = Factory::getApplication()->input->getCmd('e_name');
			
			// Get form fields
			$xml = JPATH_PLUGINS . "/editors-xtd/engagebox/form.xml";
	        $form = new Form("com_rstbox.button", array('control' => 'jform'));
	        $form->loadFile($xml, false);

	        // Remove "USESAMEBOX" option if we are not editing a box
	        if (Factory::getApplication()->input->getCmd('e_comp') != "com_rstbox")
			{
	        	unset($form->getXml()->fieldset->field[0]->option);
			}

	        // Template properties
	        $this->eName = preg_replace('#[^A-Z0-9\-\_\[\]]#i', '', $eName);
            $this->form = $form;

			parent::display($tpl);
			return;
		}

		$this->config = Tassos\EngageBox\Helper::getParams();

		HTMLHelper::stylesheet('jui/icomoon.css', array(), true);

		// Set the toolbar
		$this->addToolBar();

		// Display the template
		parent::display($tpl);
	}

	/**
	 *  Add Toolbar to layout
	 */
	protected function addToolBar()
	{
		ToolBarHelper::title(Text::_('RSTBOX'));

		$canDo 		= Joomla\CMS\Helper\ContentHelper::getActions('com_rstbox');
		$state      = $this->get('State');
		$viewLayout = Factory::getApplication()->input->get('layout', 'default');

		if ($canDo->get('core.admin'))
		{
			ToolbarHelper::preferences('com_rstbox');
		}

		ToolbarHelper::help("Help", false, 'https://www.tassos.gr/joomla-extensions/engagebox/docs');
	}
}