<?php

/**
 * @package         EngageBox
 * @version         7.1.1 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2020 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Plugin\CMSPlugin;

class plgEngageBoxPHPScripts extends CMSPlugin
{
    /**
     * The box object
     *
     * @var object
     */
    private $box;

    /**
     * Payload sent to the php scripts.
     * 
     * @var  array
     */
    private $payload = [];

    /**
     *  Auto load plugin's language file
     *
     *  @var  boolean
     */
    protected $autoloadLanguage = true;

    /**
     * Add PHP Scripts form into the box editing page
     *
     * @param  object $form
     *
     * @return void
     */
    public function onContentPrepareForm($form)
    {
        if ($form->getName() != 'com_rstbox.item')
        {
            return;
        }

        $form->loadFile(__DIR__ . '/form.xml', false);
    }

    
}