<?php

/**
 * @package         Google Structured Data
 * @version         5.6.4 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2018 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;

extract($displayData);

if (!$dimension_control_locks)
{
	return;
}
?>
<div class="tf-dimension-control--locks" title="<?php echo Text::_('NR_LINK_UNLINK_VALUES_TOGETHER'); ?>">
	<svg class="tf-dimension-control--locks--item<?php echo $is_linked ? ' active' : ''; ?>" data-type="lock" width="12" height="16" viewBox="0 0 12 16" fill="none" xmlns="http://www.w3.org/2000/svg">
		<path d="M1.5 15.875C1.0875 15.875 0.734375 15.7281 0.440625 15.4344C0.146875 15.1406 0 14.7875 0 14.375V6.875C0 6.4625 0.146875 6.10938 0.440625 5.81563C0.734375 5.52187 1.0875 5.375 1.5 5.375H2.25V3.875C2.25 2.8375 2.61563 1.95312 3.34688 1.22187C4.07812 0.490625 4.9625 0.125 6 0.125C7.0375 0.125 7.92188 0.490625 8.65313 1.22187C9.38438 1.95312 9.75 2.8375 9.75 3.875V5.375H10.5C10.9125 5.375 11.2656 5.52187 11.5594 5.81563C11.8531 6.10938 12 6.4625 12 6.875V14.375C12 14.7875 11.8531 15.1406 11.5594 15.4344C11.2656 15.7281 10.9125 15.875 10.5 15.875H1.5ZM1.5 14.375H10.5V6.875H1.5V14.375ZM6 12.125C6.4125 12.125 6.76563 11.9781 7.05938 11.6844C7.35313 11.3906 7.5 11.0375 7.5 10.625C7.5 10.2125 7.35313 9.85938 7.05938 9.56563C6.76563 9.27188 6.4125 9.125 6 9.125C5.5875 9.125 5.23438 9.27188 4.94063 9.56563C4.64687 9.85938 4.5 10.2125 4.5 10.625C4.5 11.0375 4.64687 11.3906 4.94063 11.6844C5.23438 11.9781 5.5875 12.125 6 12.125ZM3.75 5.375H8.25V3.875C8.25 3.25 8.03125 2.71875 7.59375 2.28125C7.15625 1.84375 6.625 1.625 6 1.625C5.375 1.625 4.84375 1.84375 4.40625 2.28125C3.96875 2.71875 3.75 3.25 3.75 3.875V5.375Z" fill="currentColor" />
	</svg>
	<svg class="tf-dimension-control--locks--item<?php echo !$is_linked ? ' active' : ''; ?>" data-type="unlock" width="12" height="16" viewBox="0 0 12 16" fill="none" xmlns="http://www.w3.org/2000/svg">
		<path d="M1.5 5.375H8.25V3.875C8.25 3.25 8.03125 2.71875 7.59375 2.28125C7.15625 1.84375 6.625 1.625 6 1.625C5.375 1.625 4.84375 1.84375 4.40625 2.28125C3.96875 2.71875 3.75 3.25 3.75 3.875H2.25C2.25 2.8375 2.61563 1.95312 3.34688 1.22187C4.07812 0.490625 4.9625 0.125 6 0.125C7.0375 0.125 7.92188 0.490625 8.65313 1.22187C9.38438 1.95312 9.75 2.8375 9.75 3.875V5.375H10.5C10.9125 5.375 11.2656 5.52187 11.5594 5.81563C11.8531 6.10938 12 6.4625 12 6.875V14.375C12 14.7875 11.8531 15.1406 11.5594 15.4344C11.2656 15.7281 10.9125 15.875 10.5 15.875H1.5C1.0875 15.875 0.734375 15.7281 0.440625 15.4344C0.146875 15.1406 0 14.7875 0 14.375V6.875C0 6.4625 0.146875 6.10938 0.440625 5.81563C0.734375 5.52187 1.0875 5.375 1.5 5.375ZM1.5 14.375H10.5V6.875H1.5V14.375ZM6 12.125C6.4125 12.125 6.76563 11.9781 7.05938 11.6844C7.35313 11.3906 7.5 11.0375 7.5 10.625C7.5 10.2125 7.35313 9.85938 7.05938 9.56563C6.76563 9.27188 6.4125 9.125 6 9.125C5.5875 9.125 5.23438 9.27188 4.94063 9.56563C4.64687 9.85938 4.5 10.2125 4.5 10.625C4.5 11.0375 4.64687 11.3906 4.94063 11.6844C5.23438 11.9781 5.5875 12.125 6 12.125Z" fill="currentColor" />
	</svg>
</div>
<input type="hidden" class="tf-dimension-control-link-value" value="<?php echo $is_linked ? '1' : '0'; ?>" name="<?php echo $name; ?>[linked]" />