<?php

/**
 * @package         Google Structured Data Markup
 * @version         1.0 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2016 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

class plgSystemGSD extends JPlugin
{

    /**
     *  Auto loads the plugin language file
     *
     *  @var  boolean
     */
    protected $autoloadLanguage = true;

    /**
     *  The loaded indicator of helper
     *
     *  @var  boolean
     */
    protected $init;

    /**
     *  Application Object
     *
     *  @var  object
     */
    protected $app;
	
    /**
     *  Event to add custom script tags to the document
     *
     *  @return  boolean    True on success
     */
    public function onBeforeRender()
    {

        // Load Helper
        if (!$this->getHelper())
        {
            return;
        }

        // Add Site Name strucuted data only on frontpage
        // More info: https://developers.google.com/structured-data/site-name 
        
        if ($this->params->get("sitename_enabled", true) && $this->isFrontPage())
        {

            $siteURL  = $this->params->get("sitename_url", JURI::base());
            $siteName = $this->params->get("sitename_name", JFactory::getConfig()->get('sitename'));

            $siteData = array();
            $siteData[] = '"@context": "http://schema.org"';
            $siteData[] = '"@type": "WebSite"';
            $siteData[] = '"name": "'.$siteName.'"';
            if ($this->params->get("sitename_name_alt")) {
                $siteData[] = '"alternateName": "'.$this->params->get("sitename_name_alt").'"';
            }
            $siteData[] = '"url": "'.$siteURL.'"';

			JFactory::getDocument()->addCustomTag('
                <!-- Start: '.JText::_("GSD").' -->
                <script type="application/ld+json">
                {
                    '.implode(",\n", $siteData).'
                }
                </script>
                <!-- End: '.JText::_("GSD").' -->'
            );
        }

        // Adds Breadcrumbs structured data
        // This is ideal for responsive websites that disable/hide breadcrumbs for mobile devices.
        // More info: https://developers.google.com/structured-data/breadcrumbs

        if ($this->params->get("breadcrumbs_enabled", true) && !$this->isFrontPage())
        {

        	$crumbs = $this->getCrumbs();

        	if (!$crumbs)
        	{
        		return;
        	}

			$crumbsData = array();

			foreach ($crumbs as $key => $value) {
				$crumbsData[] = '{
				    	"@type": "ListItem",
				    	"position": '.($key+1).',
				    	"item": {
				    		"@id":  "'.$value->link.'",
				    		"name": "'.$value->name.'"
						}
					}';
			}

			JFactory::getDocument()->addCustomTag('
                <!-- Start: '.JText::_("GSD").' -->
				<script type="application/ld+json">
				{
					"@context": "http://schema.org",
					"@type": "BreadcrumbList",
					"itemListElement": ['.implode(",", $crumbsData).']
				}
				</script>
                <!-- End: '.JText::_("GSD").' -->
			');
        }
    }

    /**
     *  Returns an array with crumbs
     *
     *  @return  array
     */
    private function getCrumbs()
    {

		$pathway = $this->app->getPathway();
		$items   = $pathway->getPathWay();
        $menu    = $this->app->getMenu();
        $lang    = JFactory::getLanguage();
    	$count   = count($items);

        // Look for the home menu
        if (JLanguageMultilang::isEnabled())
        {
            $home = $menu->getDefault($lang->getTag());
        }
        else
        {
            $home = $menu->getDefault();
        }

    	if (!$count)
    	{
    		return false;
    	}

		// We don't use $items here as it references JPathway properties directly
		$crumbs = array();

		for ($i = 0; $i < $count; $i ++)
		{
			$crumbs[$i] = new stdClass;
			$crumbs[$i]->name = stripslashes(htmlspecialchars($items[$i]->name, ENT_COMPAT, 'UTF-8'));
			$crumbs[$i]->link = JRoute::_($items[$i]->link, true, -1);
		}

        // Add Home item 
        $item = new stdClass;
        $item->name = htmlspecialchars($this->params->get('breadcrumbs_home', JText::_('GSD_BREADCRUMBS_HOME')));
        $item->link = JRoute::_('index.php?Itemid=' . $home->id, true, -1);
        array_unshift($crumbs, $item);

		return $crumbs;
    }

    /**
     *  Determine if the user is viewing the front page
     *
     *  @return  boolean  
     */
    private function isFrontPage()
    {
    	$menu = $this->app->getMenu();
		return ($menu->getActive() == $menu->getDefault());	
    }

    /**
     *  Loads Helper files
     *
     *  @return  bool
     */
    private function getHelper()
    {
        // Return if is helper is already loaded
        if ($this->init)
        {
            return true;
        }

        // Return if we are not in frontend
        if (!$this->app->isSite())
        {
            return false;
        }

        // Check if Novarain Framework is installed
        jimport('joomla.filesystem.file');
        if (!JFile::exists(JPATH_PLUGINS . '/system/nrframework/nrframework.php')) 
        {
            return false;
        }

        // Check if Novarain Framework is enabled
        $p = JPluginHelper::getPlugin('system', "nrframework");
        if (!isset($p->name))
        {
            return false;
        }
        
        // Load Novarain Framework Helper
        require_once JPATH_PLUGINS . '/system/nrframework/helpers/functions.php';

        // Return if current page is an XML page
        if (NRFrameworkFunctions::isFeed() || $this->app->input->getInt('print', 0))
        {
            return false;
        }

        return ($this->init = true);
    }
}
