<?php
/**
 * @package         Novarain Extensions Installer
 * @author          Tassos Marinos <info@novarain.com>
 * @link            http://www.novarain.com
 * @copyright       Copyright © 2015 Novarain All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

defined('_JEXEC') or die;

class PlgSystemNovaRainInstallerInstallerScript
{

	private $min_joomla_version = '3.4.0';
	private $min_php_version = '5.3';
	private $app;

	function __construct() {
		$this->app = JFactory::getApplication();
	}

	public function preflight($route, JAdapterInstance $adapter) {

		// Load language for messaging
		JFactory::getLanguage()->load('plg_system_novaraininstaller', __DIR__);

		if (!$this->passMinimumRequirementVersion("joomla")) {
			$this->uninstallInstaller();
			return false;
		}

		if (!$this->passMinimumRequirementVersion("php")) {
			$this->uninstallInstaller();
			return false;
		}
	}

	public function postflight($route, JAdapterInstance $adapter) {

		if (!in_array($route, array('install', 'update')))
		{
			return;
		}

		// Install the Framework
		$this->installFramework();

		// Then install the rest of the packages
		if (!$this->installPackages())
		{
			// Uninstall this installer
			$this->uninstallInstaller();
			return false;
		}

		$this->app->enqueueMessage(JText::_('NRI_PLEASE_CLEAR_YOUR_BROWSERS_CACHE'), 'notice');

		// Update Update Sites
		$this->updateSites();
		
		// Uninstall Installer
		$this->uninstallInstaller();
	}

	private function updateSites()
	{
		$helperFile = JPATH_SITE . "/plugins/system/nrframework/helpers/updatesites.php";

		if (!JFile::exists($helperFile))
		{
			return;
		}

		require_once($helperFile);

		if (!class_exists("NRUpdateSites"))
		{
			return;
		}

		// Set Download Key & fix Update Sites
		$upds = new NRUpdateSites();
		$upds->update();
	}

	private function installPackages()
	{
		$packages = JFolder::folders(__DIR__ . '/packages');

		$packages = array_diff($packages, array('plg_system_nrframework'));

		foreach ($packages as $package)
		{
			if (!$this->installPackage($package))
			{
				return false;
			}
		}

		return true;
	}

	private function installPackage($package)
	{
		$tmpInstaller = new JInstaller;
		return $tmpInstaller->install(__DIR__ . '/packages/' . $package);
	}

	private function installFramework()
	{
		return $this->installPackage('plg_system_nrframework');
	}

	private function passMinimumRequirementVersion($type = "joomla") {
		
		switch ($type) {
			case 'joomla':

				if (version_compare(JVERSION, $this->min_joomla_version, '<'))
				{

					$this->app->enqueueMessage(
						JText::sprintf('NRI_NOT_COMPATIBLE_UPDATE', JVERSION, $this->min_joomla_version),
						'error'
					);
					return false;
				}

				break;
			case 'php':

				if (version_compare(PHP_VERSION, $this->min_php_version, 'l'))
				{
					$this->app->enqueueMessage(
						JText::sprintf('NRI_NOT_COMPATIBLE_PHP', PHP_VERSION, $this->min_php_version),
						'error'
					);

					return false;
				}
				break;

			default:
				break;
		}

		return true;
	}

	private function uninstallInstaller()
	{
		if (!JFolder::exists(JPATH_SITE . '/plugins/system/novaraininstaller'))
		{
			return;
		}

		$this->deleteFolders(
			array(
				JPATH_SITE . '/plugins/system/novaraininstaller/language',
				JPATH_SITE . '/plugins/system/novaraininstaller',
			)
		);

		$db = JFactory::getDbo();

		$query = $db->getQuery(true)
			->delete('#__extensions')
			->where($db->quoteName('element') . ' = ' . $db->quote('novaraininstaller'))
			->where($db->quoteName('folder') . ' = ' . $db->quote('system'))
			->where($db->quoteName('type') . ' = ' . $db->quote('plugin'));
		$db->setQuery($query);
		$db->execute();
	}

	public function deleteFolders($folders = array())
	{
		foreach ($folders as $folder)
		{
			if (!is_dir($folder))
			{
				continue;
			}

			JFolder::delete($folder);
		}
	}
}

?>
