<?php

/**
 * @package         Smile Pack
 * @version         2.1.1-RC8 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2020 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

namespace SmilePack;

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;
use \SmilePack\Helpers\Modules as ModulesHelper;

class Modules 
{
    /**
     *  Returns all modules.
     * 
     * status values:
     * - published
     * - unpublished
     * - pro
     * - not_installed
     * - coming_soon
     *
     *  @return  array
     */
    public static function getModulesList()
    {
        return [
            'video' => [
                'icon' => '<svg width="44" height="44" viewBox="0 0 44 44" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="44" height="44" rx="5" fill="#FEDDDD"/><mask id="mask0_104_242" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="89" height="89"><rect width="89" height="89" fill="#D9D9D9"/></mask><g mask="url(#mask0_104_242)"><path d="M18.9556 27.1099L26.8872 22L18.9556 16.8901V27.1099ZM11.2974 32C10.6428 32 10.0963 31.7798 9.65778 31.3393C9.21926 30.8988 9 30.3498 9 29.6923V14.3077C9 13.6502 9.21926 13.1012 9.65778 12.6607C10.0963 12.2202 10.6428 12 11.2974 12H32.3026C32.9572 12 33.5037 12.2202 33.9422 12.6607C34.3807 13.1012 34.6 13.6502 34.6 14.3077V29.6923C34.6 30.3498 34.3807 30.8988 33.9422 31.3393C33.5037 31.7798 32.9572 32 32.3026 32H11.2974ZM11.2974 30.5714H32.3026C32.5214 30.5714 32.7219 30.4799 32.9043 30.2967C33.0866 30.1135 33.1778 29.9121 33.1778 29.6923V14.3077C33.1778 14.0879 33.0866 13.8865 32.9043 13.7033C32.7219 13.5201 32.5214 13.4286 32.3026 13.4286H11.2974C11.0786 13.4286 10.8781 13.5201 10.6957 13.7033C10.5134 13.8865 10.4222 14.0879 10.4222 14.3077V29.6923C10.4222 29.9121 10.5134 30.1135 10.6957 30.2967C10.8781 30.4799 11.0786 30.5714 11.2974 30.5714Z" fill="#1C1B1F"/></g></svg>'
            ],
            'map' => [
                'icon' => '<svg width="44" height="44" viewBox="0 0 44 44" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="44" height="44" rx="5" fill="#FEF7DD"/><mask id="mask0_104_244" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="89" height="89"><rect width="89" height="89" fill="#D9D9D9"/></mask><g mask="url(#mask0_104_244)"><path d="M18.5604 22.9296H20.9963V19.5165H23.4322V22.9296H25.8682V17.0747L22.2143 14.6329L18.5604 17.0747V22.9296ZM22.2143 33.0632C24.9196 30.7027 27.0585 28.3021 28.6308 25.8612C30.203 23.4202 30.9892 21.3091 30.9892 19.5276C30.9892 16.8879 30.1555 14.7092 28.4882 12.9916C26.8209 11.274 24.7296 10.4152 22.2143 10.4152C19.699 10.4152 17.6077 11.274 15.9404 12.9916C14.2731 14.7092 13.4394 16.8879 13.4394 19.5276C13.4394 21.3091 14.2255 23.4202 15.7978 25.8612C17.3701 28.3021 19.5089 30.7027 22.2143 33.0632ZM22.2143 35C18.8317 32.0014 16.2836 29.2048 14.5702 26.6103C12.8567 24.0159 12 21.655 12 19.5276C12 16.4753 12.9914 13.9577 14.9743 11.9746C16.9572 9.99153 19.3705 9 22.2143 9C25.0581 9 27.4714 9.99153 29.4542 11.9746C31.4371 13.9577 32.4286 16.4753 32.4286 19.5276C32.4286 21.655 31.5718 24.0159 29.8584 26.6103C28.1449 29.2048 25.5969 32.0014 22.2143 35Z" fill="#1C1B1F"/></g></svg>'
            ],
            'accordion' => [
                'icon' => '<svg width="44" height="44" viewBox="0 0 44 44" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="44" height="44" fill="#DDEEFE"/><mask id="mask0_181_276" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="44" height="44"><rect width="44" height="44" fill="#D9D9D9"/></mask><g mask="url(#mask0_181_276)"><path d="M11.3077 32C10.6502 32 10.1012 31.7798 9.66071 31.3393C9.22024 30.8988 9 30.3498 9 29.6923V14.3077C9 13.6502 9.22024 13.1012 9.66071 12.6607C10.1012 12.2202 10.6502 12 11.3077 12H32.4066C33.0641 12 33.6131 12.2202 34.0536 12.6607C34.494 13.1012 34.7143 13.6502 34.7143 14.3077V29.6923C34.7143 30.3498 34.494 30.8988 34.0536 31.3393C33.6131 31.7798 33.0641 32 32.4066 32H11.3077ZM10.4286 24.8571H33.2857V14.3077C33.2857 14.0879 33.1941 13.8865 33.011 13.7033C32.8278 13.5201 32.6264 13.4286 32.4066 13.4286H11.3077C11.0879 13.4286 10.8865 13.5201 10.7033 13.7033C10.5201 13.8865 10.4286 14.0879 10.4286 14.3077V24.8571Z" fill="#3A4B5F"/></g></svg>'
            ],
            'gallery' => [
                'icon' => '<svg width="44" height="44" viewBox="0 0 44 44" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="44" height="44" rx="5" fill="#F5FEDD"/><mask id="mask0_104_339" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="89" height="89"><rect width="89" height="89" fill="#D9D9D9"/></mask><g mask="url(#mask0_104_339)"><path d="M10.4048 31C9.7435 31 9.17736 30.7627 8.7064 30.2882C8.23547 29.8137 8 29.2433 8 28.5769V15.4231C8 14.7567 8.23547 14.1863 8.7064 13.7118C9.17736 13.2373 9.7435 13 10.4048 13H23.4598C24.1212 13 24.6873 13.2373 25.1582 13.7118C25.6292 14.1863 25.8647 14.7567 25.8647 15.4231V28.5769C25.8647 29.2433 25.6292 29.8137 25.1582 30.2882C24.6873 30.7627 24.1212 31 23.4598 31H10.4048ZM30.0587 20.5C29.7038 20.5 29.4123 20.3851 29.1842 20.1553C28.9561 19.9255 28.8421 19.6318 28.8421 19.2742V14.2258C28.8421 13.8682 28.9561 13.5745 29.1842 13.3447C29.4123 13.1149 29.7038 13 30.0587 13H35.0691C35.424 13 35.7155 13.1149 35.9436 13.3447C36.1717 13.5745 36.2857 13.8682 36.2857 14.2258V19.2742C36.2857 19.6318 36.1717 19.9255 35.9436 20.1553C35.7155 20.3851 35.424 20.5 35.0691 20.5H30.0587ZM30.3308 19H34.797V14.5H30.3308V19ZM10.4048 29.5H23.4598C23.727 29.5 23.9465 29.4135 24.1183 29.2404C24.2901 29.0673 24.3759 28.8462 24.3759 28.5769V15.4231C24.3759 15.1538 24.2901 14.9327 24.1183 14.7596C23.9465 14.5865 23.727 14.5 23.4598 14.5H10.4048C10.1376 14.5 9.91816 14.5865 9.74638 14.7596C9.57461 14.9327 9.48872 15.1538 9.48872 15.4231V28.5769C9.48872 28.8462 9.57461 29.0673 9.74638 29.2404C9.91816 29.4135 10.1376 29.5 10.4048 29.5ZM11.2637 26.3558H22.6009L18.9793 21.4808L16.188 25.2308L14.141 22.4933L11.2637 26.3558ZM30.0587 31C29.7038 31 29.4123 30.8851 29.1842 30.6553C28.9561 30.4255 28.8421 30.1318 28.8421 29.7742V24.7258C28.8421 24.3682 28.9561 24.0745 29.1842 23.8447C29.4123 23.6149 29.7038 23.5 30.0587 23.5H35.0691C35.424 23.5 35.7155 23.6149 35.9436 23.8447C36.1717 24.0745 36.2857 24.3682 36.2857 24.7258V29.7742C36.2857 30.1318 36.1717 30.4255 35.9436 30.6553C35.7155 30.8851 35.424 31 35.0691 31H30.0587ZM30.3308 29.5H34.797V25H30.3308V29.5Z" fill="#1C1B1F"/></g></svg>'
            ],
            'paypal' => [
                'icon' => '<svg width="44" height="44" viewBox="0 0 44 44" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="44" height="44" fill="#EEF5F9"/><path d="M31.4542 15.2341C31.5016 14.8488 31.5264 14.4565 31.5264 14.0584C31.5264 10.7125 28.8139 8 25.4679 8H15.343C14.7061 8 14.1623 8.45992 14.0567 9.08795L10.3259 31.2624C10.192 32.0581 10.8054 32.7832 11.6122 32.7832H15.3151C15.952 32.7832 16.506 32.3236 16.6116 31.6955C16.6116 31.6955 16.6178 31.6587 16.6289 31.5924H16.629L16.113 34.6596C15.9951 35.3609 16.5356 36 17.2467 36H20.4863C21.0476 36 21.5269 35.5946 21.62 35.0411L22.5403 29.5712C22.699 28.6283 23.5153 27.9379 24.4714 27.9379H25.3224C29.9452 27.9379 33.6926 24.1904 33.6926 19.5677C33.6926 17.7789 32.8084 16.1978 31.4542 15.2341Z" fill="#002987"/><path d="M31.4541 15.2341C30.8748 19.947 26.858 23.5963 21.9885 23.5963H19.1631C18.5254 23.5963 17.9746 24.0211 17.8018 24.6217L16.113 34.6595C15.995 35.3608 16.5356 36 17.2467 36H20.4862C21.0476 36 21.5269 35.5946 21.62 35.0411L22.5403 29.5712C22.6989 28.6283 23.5153 27.9379 24.4714 27.9379H25.3224C29.9451 27.9379 33.6926 24.1904 33.6926 19.5677C33.6926 17.779 32.8084 16.1978 31.4541 15.2341Z" fill="#0085CC"/><path d="M19.1631 23.5963H21.9885C26.8581 23.5963 30.8749 19.947 31.4542 15.2341C30.5853 14.6158 29.5235 14.2509 28.3758 14.2509H21.0012C20.1616 14.2509 19.4447 14.8573 19.3053 15.6852L17.8018 24.6216C17.9746 24.021 18.5254 23.5963 19.1631 23.5963Z" fill="#00186A"/></svg>'
            ],
            'tabs' => [
                'icon' => '<svg width="44" height="44" viewBox="0 0 44 44" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="44" height="44" fill="#DDFEF8"/><mask id="mask0_181_260" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="44" height="44"><rect width="44" height="44" fill="#3A4B5F"/></mask><g mask="url(#mask0_181_260)"><path d="M11.3333 30.5714H32.6667C32.8889 30.5714 33.0926 30.4799 33.2778 30.2967C33.463 30.1135 33.5556 29.9121 33.5556 29.6923V19.1429H23.4444V13.4286H11.3333C11.1111 13.4286 10.9074 13.5201 10.7222 13.7033C10.537 13.8865 10.4444 14.0879 10.4444 14.3077V29.6923C10.4444 29.9121 10.537 30.1135 10.7222 30.2967C10.9074 30.4799 11.1111 30.5714 11.3333 30.5714ZM11.3333 32C10.6685 32 10.1134 31.7798 9.66806 31.3393C9.22269 30.8988 9 30.3498 9 29.6923V14.3077C9 13.6502 9.22269 13.1012 9.66806 12.6607C10.1134 12.2202 10.6685 12 11.3333 12H32.6667C33.3315 12 33.8866 12.2202 34.3319 12.6607C34.7773 13.1012 35 13.6502 35 14.3077V29.6923C35 30.3498 34.7773 30.8988 34.3319 31.3393C33.8866 31.7798 33.3315 32 32.6667 32H11.3333Z" fill="#3A4B5F"/></g></svg>',
                'status' => 'coming_soon'
            ],
            'related_articles' => [
                'icon' => '<svg width="44" height="44" viewBox="0 0 44 44" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="44" height="44" rx="5" fill="#DDFEDD"/><mask id="mask0_104_349" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="4" y="4" width="37" height="37"><rect x="4" y="4" width="37" height="37" fill="#D9D9D9"/></mask><g mask="url(#mask0_104_349)"><path d="M10.1666 34.8333V28.6667H15.3846L21.7291 22.3221V17.8631C20.8436 17.6279 20.1084 17.1679 19.5233 16.4831C18.9383 15.7982 18.6458 14.9972 18.6458 14.0801C18.6458 13.0128 19.0213 12.1036 19.7724 11.3526C20.5235 10.6015 21.4326 10.226 22.5 10.226C23.5673 10.226 24.4765 10.6015 25.2275 11.3526C25.9786 12.1036 26.3541 13.0128 26.3541 14.0801C26.3541 14.9972 26.0616 15.7982 25.4766 16.4831C24.8915 17.1679 24.1563 17.6279 23.2708 17.8631V22.3221L29.6153 28.6667H34.8333V34.8333H28.6666V29.9534L22.5 23.7867L16.3333 29.9534V34.8333H10.1666Z" fill="#1C1B1F"/></g></svg>',
                'status' => 'coming_soon'
            ],
            'random_module' => [
                'icon' => '<svg width="44" height="44" viewBox="0 0 44 44" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="44" height="44" fill="#E9DDFE"/><mask id="mask0_181_458" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="44" height="44"><rect width="44" height="44" fill="#D9D9D9"/></mask><g mask="url(#mask0_181_458)"><path d="M25.1868 32V30.5714H29.6154L24.5852 25.5412L25.6044 24.522L30.5714 29.489V25.2692H32V32H25.1868ZM13.011 32L12 30.989L29.5604 13.4286H25.1868V12H32V18.7308H30.5714V14.4396L13.011 32ZM18.2665 19.25L12 12.9835L12.9835 12L19.25 18.2665L18.2665 19.25Z" fill="#3A4B5F"/></g></svg>',
                'status' => 'coming_soon'
            ]
        ];
    }

    /**
     * Returns all modules with their details.
     * 
     * @return  array
     */
    public static function getModules()
    {
        $modules = self::getModulesList();

        foreach ($modules as $module_slug => &$module)
        {
            $payload = [
                'name' => Text::_('COM_SMILEPACK_MODULE_' . strtoupper($module_slug)),
                'description' => Text::_('COM_SMILEPACK_MODULE_' . strtoupper($module_slug) . '_DESC'),
                'status' => isset($module['status']) ? $module['status'] : '',
            ];

            // If no status is set or status is empty, get the module status from the database
            if (!isset($module['status']) || (isset($module['status']) && empty($module['status'])))
            {
                $status = ModulesHelper::getModuleStatus('mod_sp' . $module_slug);

                // If no status is set, set it to not_installed, else set it to the status from the database
                $payload['status'] = is_null($status) ? 'not_installed' : $status;
            }

            // If the module is published or unpublished, set the total modules and help url
            if (in_array($payload['status'], ['published', 'unpublished']))
            {
                // Set total modules
                $payload['total_modules'] = ModulesHelper::getTotalModulesByName('mod_sp' . $module_slug);
                
                // Set help url
                $payload['help_url'] = 'https://www.tassos.gr/joomla-extensions/smile-pack/docs/' . $module_slug . '-module';
            }
            
            $module = array_merge($module, $payload);
        }
        
        return $modules;
    }
}